<?php
namespace App\Http\Controllers\admin;
use App\Http\Controllers\Controller;
use App\Http\Requests;
use App\Permission;
use Illuminate\Http\Request;
use Illuminate\Pagination\Paginator;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Auth;
use Maatwebsite\Excel\Facades\Excel;
use Nicolaslopezj\Searchable\SearchableTrait;
use Validator;
use Zizaco\Entrust\Traits\EntrustUserTrait;
use Salesforce;
use App\sfdc\soapclient\SforceBaseClient;
use Regulus\ActivityLog\Models\Activity;
use Davispeixoto\ForceDotComToolkitForPhp\SforceEnterpriseClient;
use Session;
use DB;
use File;
use DateTime;
class PaymentController extends Controller
{
	public function PaymentList()
    {
    	$title = "Payment List";

        $salesforce_Id     = Session::get('salesforce_Id');

		$activity = 'you are logged in';
        Activity::log($activity);
        $facilitylist  = Salesforce::query("SELECT Id,Name FROM Account WHERE Client_Contact__c = '" . $salesforce_Id . "'");

        $charges =array();
        foreach ($facilitylist->records as $facility) {
        $facility_id = $facility->Id;
        $facility_name = $facility->Name;
        $chargent_orders  = Salesforce::query("SELECT ChargentOrders__Account__r.name,ChargentOrders__Account__c,ChargentOrders__Card_Expiration_Month__c,ChargentOrders__Card_Expiration_Year__c,ChargentOrders__Card_Last_4__c,ChargentOrders__Card_Month_Indicator__c,ChargentOrders__Card_Number__c,ChargentOrders__Card_Security_Code__c,ChargentOrders__Card_Type__c,ChargentOrders__Card_Year_Indicator__c,ChargentOrders__Charge_Amount__c,ChargentOrders__Manual_Charge__c,ChargentOrders__No_Tax__c,ChargentOrders__OrderSource__c,ChargentOrders__Payment_Frequency__c,ChargentOrders__Payment_Method__c,ChargentOrders__Payment_Received__c,ChargentOrders__Payment_Status__c,ChargentOrders__Tax_Exempt__c,ChargentOrders__Tax__c,ChargentOrders__Tokenization__c,ChargentOrders__Balance_Due__c,ChargentOrders__Bank_Account_Name__c,ChargentOrders__Bank_Account_Number__c,ChargentOrders__Bank_Account_Type__c,ChargentOrders__Bank_Name__c,ChargentOrders__Bank_Routing_Number__c,ChargentOrders__Billing_Address_Line_2__c,ChargentOrders__Billing_Address__c,ChargentOrders__Billing_City__c,ChargentOrders__Billing_Company__c,ChargentOrders__Billing_Country__c,ChargentOrders__Billing_Email__c,ChargentOrders__Billing_Fax__c,ChargentOrders__Billing_First_Name__c,ChargentOrders__Billing_Last_Name__c,ChargentOrders__Billing_Phone__c,ChargentOrders__Billing_State_Province__c,ChargentOrders__Billing_State__c,ChargentOrders__Billing_Zip_Postal__c,ChargentOrders__Subtotal__c,ChargentOrders__Status__c,Name,ChargentOrders__Date__c FROM ChargentOrders__ChargentOrder__c WHERE ChargentOrders__Account__c ='". $facility_id ."'");
       $chargent_order = $chargent_orders->records;
        $charges[$facility_name] = $chargent_order;
       


        }

       return view('admin.paymentlist', compact('charges','activities_list','title','chargent_orders','payment_count'));
    }
    public function AddPaymentlist()
    {
    	 $title = 'Add Payment'; 
    	$salesforce_Id = Session::get('salesforce_Id');
		$activity = 'you Added payment list';
        Activity::log($activity);

        $facilitylist  = Salesforce::query("SELECT Id,Name FROM Account WHERE Client_Contact__c = '" . $salesforce_Id . "'");

        $charges =array();
         $chargent_order = array();
        $fids =array();
        $facility_id = 0;
        $count_payment = 0;
        
       $facility_count= count($facilitylist->records);
       if( $facility_count>0){
        foreach ($facilitylist->records as $facility) {
        $facility_id = $facility->Id;
        	$a = "'".$facility->Id."'";
        	array_push($fids, $a);
    	}

    	//print_r($fids); die;
    	$ss= "(".implode($fids, ',').")";
    	//echo $ss; die;

        $facility_name = $facility->Name;
        $chargent_orders  = Salesforce::query("SELECT ChargentOrders__Account__r.name,	Account_Name__c,Id,ChargentOrders__Account__c,ChargentOrders__Card_Expiration_Month__c,ChargentOrders__Card_Expiration_Year__c,ChargentOrders__Card_Last_4__c,ChargentOrders__Card_Month_Indicator__c,ChargentOrders__Card_Number__c,ChargentOrders__Card_Security_Code__c,ChargentOrders__Card_Type__c,ChargentOrders__Card_Year_Indicator__c,ChargentOrders__Charge_Amount__c,ChargentOrders__Manual_Charge__c,ChargentOrders__No_Tax__c,ChargentOrders__OrderSource__c,ChargentOrders__Payment_Frequency__c,ChargentOrders__Payment_Method__c,ChargentOrders__Payment_Received__c,ChargentOrders__Payment_Status__c,ChargentOrders__Tax_Exempt__c,ChargentOrders__Tax__c,ChargentOrders__Tokenization__c,ChargentOrders__Balance_Due__c,ChargentOrders__Bank_Account_Name__c,ChargentOrders__Bank_Account_Number__c,ChargentOrders__Bank_Account_Type__c,ChargentOrders__Bank_Name__c,ChargentOrders__Bank_Routing_Number__c,ChargentOrders__Billing_Address_Line_2__c,ChargentOrders__Billing_Address__c,ChargentOrders__Billing_City__c,ChargentOrders__Billing_Company__c,ChargentOrders__Billing_Country__c,ChargentOrders__Billing_Email__c,ChargentOrders__Billing_Fax__c,ChargentOrders__Billing_First_Name__c,ChargentOrders__Billing_Last_Name__c,ChargentOrders__Billing_Phone__c,ChargentOrders__Billing_State_Province__c,ChargentOrders__Billing_State__c,ChargentOrders__Billing_Zip_Postal__c,ChargentOrders__Subtotal__c,ChargentOrders__Status__c,Name,ChargentOrders__Date__c FROM ChargentOrders__ChargentOrder__c WHERE ChargentOrders__Account__c in $ss AND ChargentOrders__Date__c != NULL order by ChargentOrders__Date__c DESC NULLS LAST");
    	//print_r(count($chargent_orders->records));die;
       $chargent_order = $chargent_orders->records;
        $charges[$facility_name] = $chargent_order;

   
         $count_payment = Salesforce::query(" SELECT count(Name) FROM Account WHERE Client_Contact__c = '" . $salesforce_Id . "'");
        $payment_count =$count_payment->records[0]->any['expr0'];

         $count_chargent = Salesforce::query("SELECT count(Name) FROM ChargentOrders__ChargentOrder__c WHERE ChargentOrders__Account__c ='". $facility_id ."'");
        $chargent_count =$count_chargent->records[0]->any['expr0'];
       }
        $add_paymentlist  = Salesforce::query("SELECT Address__c,FID__c,Id,MGT__c,Name,USSBOA_Paid_Service__c,MGT_Paid_Service__c,BillingAddress,BillingCity,BillingCountry,BillingGeocodeAccuracy,BillingLatitude,BillingLongitude,BillingPostalCode,BillingState,BillingStreet,City__c FROM Account WHERE Client_Contact__c = '" . $salesforce_Id . "'");

       	$fid = $facility_id;

    	return view('admin.add_paymentlist', compact('add_paymentlist','activities_list','title','charges','fid', 'fid_details','payment_count','chargent_count','chargent_order'));
    }
    public function Add_Paymentlist($id)
    {
    	 $title = 'Add Payment'; 
    	$salesforce_Id = Session::get('salesforce_Id');

		$activity = 'you have visited AddPaymentlist';
        Activity::log($activity);

        $facilitylist  = Salesforce::query("SELECT Id,Name,BillingAddress,BillingCity,BillingCountry,BillingGeocodeAccuracy,BillingLatitude,BillingLongitude,BillingPostalCode,BillingState,BillingStreet,City__c FROM Account WHERE Client_Contact__c = '" . $salesforce_Id . "'");

        $charges =array();
        foreach ($facilitylist->records as $facility) {
        $facility_id = $facility->Id;
        $facility_name = $facility->Name;
        $chargent_orders  = Salesforce::query("SELECT ChargentOrders__Account__r.name,ChargentOrders__Date__c,ChargentOrders__Account__c,ChargentOrders__Card_Expiration_Month__c,ChargentOrders__Card_Expiration_Year__c,ChargentOrders__Card_Last_4__c,ChargentOrders__Card_Month_Indicator__c,ChargentOrders__Card_Number__c,ChargentOrders__Card_Security_Code__c,ChargentOrders__Card_Type__c,ChargentOrders__Card_Year_Indicator__c,ChargentOrders__Charge_Amount__c,ChargentOrders__Manual_Charge__c,ChargentOrders__No_Tax__c,ChargentOrders__OrderSource__c,ChargentOrders__Payment_Frequency__c,ChargentOrders__Payment_Method__c,ChargentOrders__Payment_Received__c,ChargentOrders__Payment_Status__c,ChargentOrders__Tax_Exempt__c,ChargentOrders__Tax__c,ChargentOrders__Tokenization__c,ChargentOrders__Balance_Due__c,ChargentOrders__Bank_Account_Name__c,ChargentOrders__Bank_Account_Number__c,ChargentOrders__Bank_Account_Type__c,ChargentOrders__Bank_Name__c,ChargentOrders__Bank_Routing_Number__c,ChargentOrders__Billing_Address_Line_2__c,ChargentOrders__Billing_Address__c,ChargentOrders__Billing_City__c,ChargentOrders__Billing_Company__c,ChargentOrders__Billing_Country__c,ChargentOrders__Billing_Email__c,ChargentOrders__Billing_Fax__c,ChargentOrders__Billing_First_Name__c,ChargentOrders__Billing_Last_Name__c,ChargentOrders__Billing_Phone__c,ChargentOrders__Billing_State_Province__c,ChargentOrders__Billing_State__c,ChargentOrders__Billing_Zip_Postal__c,ChargentOrders__Subtotal__c,ChargentOrders__Status__c,Name FROM ChargentOrders__ChargentOrder__c WHERE ChargentOrders__Account__c ='". $facility_id ."'");
       $chargent_order = $chargent_orders->records;
        $charges[$facility_name] = $chargent_order;

        }
        $add_paymentlist  = Salesforce::query("SELECT Address__c,FID__c,Id,MGT__c,Name,USSBOA_Paid_Service__c,MGT_Paid_Service__c,BillingAddress,BillingCity,BillingCountry,BillingGeocodeAccuracy,BillingLatitude,BillingLongitude,BillingPostalCode,BillingState,BillingStreet,City__c FROM Account WHERE Client_Contact__c = '" . $salesforce_Id . "'");
			$fid = $id;


        
    	$count_payment = Salesforce::query(" SELECT count(Name) FROM Account WHERE Client_Contact__c = '" . $salesforce_Id . "'");
        $payment_count =$count_payment->records[0]->any['expr0'];

        $count_chargent = Salesforce::query("SELECT count(Name) FROM ChargentOrders__ChargentOrder__c WHERE ChargentOrders__Account__c ='". $salesforce_Id ."'");
        $chargent_count =$count_chargent->records[0]->any['expr0'];
    	return view('admin.add_paymentlist', compact('add_paymentlist','activities_list','title','charges','fid','payment_count','chargent_count'));
    }
    
    public function Paymentreview(Request $request)
    {
    	$title = 'Add Payment';
    	$salesforce_Id     = Session::get('salesforce_Id');

		$activity = 'you have visited the Payment review';
        Activity::log($activity);
		
		$f_ids = $request->f_id;
    	if(isset($request->ussboa)){
			$ussboa = $request->ussboa;
		}else{
			$ussboa = array();			
		}
		
		if(isset($request->mgt)){
			$mgt = $request->mgt;
		}else{
			$mgt = array();			
		}
		
		$ussboa_total = 0;
		$mgt_total = 0;
		$total = 0;
		$fids_details = array();		
		foreach($f_ids as $f_id){	
			$fid_details = array();		
			$details = Salesforce::query("SELECT Id, Address__c, Name, FID__c, USSBOA_Paid_Service__c,MGT_Paid_Service__c FROM Account WHERE FID__c = '" . $f_id . "'"); 	
			//print_r($details);
			if (in_array($f_id, $ussboa)) {
				$fid_details['Id'] = isset($details->records[0]->Id)?$details->records[0]->Id:'';
				$fid_details['FID__c'] = isset($details->records[0]->FID__c)?$details->records[0]->FID__c:''; 
				$fid_details['Name'] = isset($details->records[0]->Name)?$details->records[0]->Name:'';
				$fid_details['Address__c'] = isset($details->records[0]->Address__c)?$details->records[0]->Address__c:'';
				$fid_details['USSBOA_Paid_Service__c'] = isset($details->records[0]->Address__c)?$details->records[0]->Address__c:'';
				$fid_details['MGT_Paid_Service__c'] = isset($details->records[0]->Address__c)?$details->records[0]->Address__c:'';
				$fid_details['ussboa'] = 99.99;
				$ussboa_total = $ussboa_total +99.99;
			}
			
			if (in_array($f_id, $mgt)) {
				$fid_details['Id'] = isset($details->records[0]->Id)?$details->records[0]->Id:'';
				$fid_details['FID__c'] = isset($details->records[0]->FID__c)?$details->records[0]->FID__c:''; 
				$fid_details['Name'] = isset($details->records[0]->Name)?$details->records[0]->Name:'';
				$fid_details['Address__c'] = isset($details->records[0]->Address__c)?$details->records[0]->Address__c:'';
				$fid_details['USSBOA_Paid_Service__c'] = isset($details->records[0]->Address__c)?$details->records[0]->Address__c:'';
				$fid_details['MGT_Paid_Service__c'] = isset($details->records[0]->Address__c)?$details->records[0]->Address__c:'';
				$fid_details['mgs'] = 19.99;
				$mgt_total = $mgt_total +19.99;
			}
			
			array_push($fids_details,$fid_details);
		}
		$ussboa_total_view = $ussboa_total; 
		$mgt_total_view = $mgt_total;

		$total = $mgt_total+$ussboa_total;

		Session::set('fids_details', $fids_details);
		Session::set('total', $total);
		Session::set('ussboa_tot',$ussboa_total_view);
		Session::set('mgt_tot',$mgt_total_view);
    	return redirect('admin/paymentmethod');
    }
	public function PaymentMethod(){

		$title = 'Payment Method';
		$salesforce_Id     = Session::get('salesforce_Id');

		
		$activity = 'you entered into payment method';
        Activity::log($activity);
		
		$fids_details = Session::get('fids_details');
		$total = Session::get('total');
		$uss_total = Session::get('ussboa_tot');
		$mg_total = Session::get('mgt_tot');
		
    	return view('admin.paymentmethod', compact('fids_details', 'total','activities_list','title'));
		
	}
	
	public function OrderSummery(Request $request){

		$title = 'Order Summery';
		$salesforce_Id     = Session::get('salesforce_Id');

		
		$activity = 'you have checked order summary';
        Activity::log($activity);
		$details = $request->all();
		Session::set('details', $details);
		
		$fids_details = Session::get('fids_details');
		$total = Session::get('total');
		$uss_total = Session::get('ussboa_tot');
		$mg_total = Session::get('mgt_tot');
		

		
		return view('admin.ordersummary',compact('details','fids_details','total','activities_list','title','uss_total','mg_total'));
	}

	public function OrderSubmit(){
		
		$fids_details = Session::get('fids_details');

		if (!isset($fids_details) && $fids_details == '') {
    		
    		return redirect('admin/addpaymentlist');
		}
		$activity = 'you Submited the order';
        Activity::log($activity);
		
		date_default_timezone_set("Asia/Kolkata");
		$dt = new \DateTime();
        // $dt->setTimeZone(new \DateTimeZone('UTC+5:30'));
        $last_payment_date = $dt->format('Y-m-d\TH:i:s.\0\0\0\Z');
        
		$title = 'Order Submit';
		$salesforce_Id     = Session::get('salesforce_Id');
		$total = Session::get('total');
		$manual_charge = '1';
		$pay_status = '0';
		$paid_status = '1';
		$reccuring = $_REQUEST['Reccuring'];
		$details = Session::get('details');
		$fids_details = Session::get('fids_details'); 

		Session::forget('total');
		Session::forget('details');

		
		$FIds = $details['FId'];
		//Code By DANDA
		$F_amount = $details['F_amount'];
		$payment_status = $details['payment_status'];
		
		$orders_insert_ids = array();
		$orders_insert_ids_success = array();
		if($payment_status == 'Credit_Card'){
			foreach($FIds as $k=>$FId){
				$sObject                 = new \stdclass();			
				$sObject->ChargentOrders__Account__c           = $FId;
				$sObject->ChargentOrders__Card_Number__c           = $details['creditcard_number'];
				$sObject->ChargentOrders__Card_Expiration_Month__c       = $details['creditcard_expmonth'];
				$sObject->ChargentOrders__Card_Expiration_Year__c       = $details['creditcard_expyear'];
				$sObject->ChargentOrders__Manual_Charge__c 	 = '1';
				$sObject->ChargentOrders__Card_Security_Code__c    = $details['creditcard_cvv'];
				$sObject->ChargentOrders__Bank_Account_Name__c 	 = $details['creditcard_name']; 
				$sObject->ChargentOrders__Card_Type__c 	 = str_replace("_"," ",$payment_status); 
				$sObject->ChargentOrders__Payment_Method__c 	 = str_replace("_"," ",$payment_status); 
				$sObject->ChargentOrders__Payment_Status__c 	 = $reccuring; 
				$sObject->ChargentOrders__Charge_Amount__c 	 = $F_amount[$k];
				$sObject->ChargentOrders__Billing_Address__c    = $details['creditcard_address'];
				$sObject->ChargentOrders__Billing_City__c    = $details['creditcard_city'];
				$sObject->ChargentOrders__Billing_State__c    = $details['creditcard_state'];
				$sObject->ChargentOrders__Billing_Zip_Postal__c    = $details['creditcard_pin'];
				$sObject->ChargentOrders__Billing_Email__c           = $details['creditcard_email'];
				$sObject->ChargentOrders__Date__c           = $last_payment_date;
				
				$upsertResponse_create = Salesforce::create(array($sObject),'ChargentOrders__ChargentOrder__c');
				
				$sObjecttwo                 = new \stdclass();
				$sObjecttwo->Id                           = $FId;	
				
				if($fids_details){
					foreach ($fids_details as $value) {
						if($value){
							$fid = $value['Id'];
							if($fid == $FId){
								if(isset($value['ussboa'])){
									$sObjecttwo->USSBOA_Paid_Service__c = '1';
								}
								if(isset($value['mgs'])){
									$sObjecttwo->MGT_Paid_Service__c = '1';
								}
							}
						}
					}
				}
				
				$upsertResponse          = Salesforce::update(array($sObjecttwo),'Account');
				
				$order_id = $upsertResponse[0]->id;
				array_push($orders_insert_ids,$order_id);
				$order_id_success = "'".$upsertResponse_create[0]->id."'";
				array_push($orders_insert_ids_success,$order_id_success);
			}
		}else if($payment_status == 'Debit_Card'){
			
			foreach($FIds as $k=>$FId){
				$sObject  = new \stdclass();			
				$sObject->ChargentOrders__Account__c           = $FId;
				$sObject->ChargentOrders__Card_Number__c           = $details['creditcard_number'];
				$sObject->ChargentOrders__Card_Expiration_Month__c       = $details['debitcard_expmonth'];
				$sObject->ChargentOrders__Card_Expiration_Year__c       = $details['debitcard_expyear'];
				$sObject->ChargentOrders__Card_Security_Code__c    = $details['debitcard_cvv'];
				$sObject->ChargentOrders__Bank_Account_Name__c 	 = $details['debitcard_name']; 
				$sObject->ChargentOrders__Card_Type__c 	 = str_replace( "_" ," ", $payment_status); 
				$sObject->ChargentOrders__Manual_Charge__c 	 = $manual_charge; 
				
				$sObject->ChargentOrders__Payment_Status__c 	 = $reccuring;
				$sObject->ChargentOrders__Payment_Method__c 	 = str_replace( "_" ," ", $payment_status); 
				$sObject->ChargentOrders__Charge_Amount__c 	 = $F_amount[$k];
				$sObject->ChargentOrders__Billing_Address__c    = $details['creditcard_address'];
				$sObject->ChargentOrders__Billing_City__c    = $details['creditcard_city'];
				$sObject->ChargentOrders__Billing_State__c    = $details['creditcard_state'];
				$sObject->ChargentOrders__Billing_Zip_Postal__c    = $details['creditcard_pin'];
				$sObject->ChargentOrders__Billing_Email__c           = $details['creditcard_email'];
				$sObject->ChargentOrders__Date__c           = $last_payment_date;	
				
				$upsertResponse_create          = Salesforce::create(array($sObject),'ChargentOrders__ChargentOrder__c');
				$sObjecttwo                 = new \stdclass();
				$sObjecttwo->Id                           = $FId;	
				
				if($fids_details){
					foreach ($fids_details as $value) {
						if($value){
							$fid = $value['Id'];
							if($fid == $FId){
								if(isset($value['ussboa'])){
									$sObjecttwo->USSBOA_Paid_Service__c = '1';
								}
								if(isset($value['mgs'])){
									$sObjecttwo->MGT_Paid_Service__c = '1';
								}
							}
						}
					}
				}
				$upsertResponse = Salesforce::update(array($sObjecttwo),'Account');
				
				$order_id = $upsertResponse[0]->id;
				array_push($orders_insert_ids,$order_id);
				$order_id_success = "'".$upsertResponse_create[0]->id."'";
				array_push($orders_insert_ids_success,$order_id_success);
			}
			
		}else if($payment_status == 'Net_banking'){

			foreach($FIds as $k=>$FId){
				//print_r($F_amount[$k]);die;
				$sObject                 = new \stdclass();			
				$sObject->ChargentOrders__Account__c           = $FId;
				$sObject->ChargentOrders__Bank_Account_Number__c           = $details['check_acnumber'];
				$sObject->ChargentOrders__Check_Number__c        = $details['check_number'];
				$sObject->ChargentOrders__Bank_Routing_Number__c   = $details['routing_number'];
				$sObject->ChargentOrders__Bank_Name__c        = $details['check_bankname'];
				$sObject->ChargentOrders__Bank_Account_Name__c 	 = $details['check_holder_name']; 
				$sObject->ChargentOrders__Bank_Account_Type__c 	 = $details['account_type_netbanking']; 
				$sObject->ChargentOrders__Manual_Charge__c 	 = $manual_charge;
				$sObject->ChargentOrders__Card_Type__c 	 = 'Check'; 
				$sObject->ChargentOrders__Payment_Method__c 	 = str_replace("_"," ",$payment_status);
				$sObject->ChargentOrders__Payment_Status__c 	 = $reccuring; 
				$sObject->ChargentOrders__Charge_Amount__c 	 = $F_amount[$k];
				$sObject->ChargentOrders__Billing_Address__c    = $details['creditcard_address'];
				$sObject->ChargentOrders__Billing_City__c    = $details['creditcard_city'];
				$sObject->ChargentOrders__Billing_State__c    = $details['creditcard_state'];
				$sObject->ChargentOrders__Billing_Zip_Postal__c    = $details['creditcard_pin'];
				$sObject->ChargentOrders__Billing_Email__c           = $details['creditcard_email'];
				$sObject->ChargentOrders__Date__c           = $last_payment_date;
				
				$upsertResponse_create   = Salesforce::create(array($sObject),'ChargentOrders__ChargentOrder__c');
				
				$sObjecttwo  = new \stdclass();
				$sObjecttwo->Id                           = $FId;	
				if($fids_details){
					foreach ($fids_details as $value) {
						if($value){
							$fid = $value['Id'];
							if($fid == $FId){
								if(isset($value['ussboa'])){
									$sObjecttwo->USSBOA_Paid_Service__c = '1';
								}
								if(isset($value['mgs'])){
									$sObjecttwo->MGT_Paid_Service__c = '1';
								}
							}
						}
					}
				}
				$upsertResponse = Salesforce::update(array($sObjecttwo),'Account');
				
				$order_id = $upsertResponse[0]->id;

				$order_id_success = "'".$upsertResponse_create[0]->id."'";

				array_push($orders_insert_ids,$order_id);

				array_push($orders_insert_ids_success,$order_id_success);
			}
		}
		$orders_insert_ids_impl = implode(',',$orders_insert_ids);

		$ss    = "(".implode($orders_insert_ids_success, ',').")";

		$chargent_orders  = Salesforce::query("SELECT Id,Name,CreatedDate FROM ChargentOrders__ChargentOrder__c WHERE Id in $ss");
		
		Session::flash('order_status', 'Orders '. $orders_insert_ids_impl .' was successfully Submited!');
		
		$date = date('d-M-Y', strtotime($chargent_orders->records[0]->CreatedDate));
		Session::forget('fids_details');		
		
		return view('admin.payment_success',compact('total','chargent_orders','date'));
	}
	public function OrederView($id){
		$title = "Order View";

        $salesforce_Id     = Session::get('salesforce_Id');
        $activity = 'you visited the Order View';
        Activity::log($activity);

		
        $facilitylist  = Salesforce::query("SELECT Id,Name FROM Account WHERE Client_Contact__c = '" . $salesforce_Id . "'");

        $charges =array();
        foreach ($facilitylist->records as $facility) {
        $facility_id = $facility->Id;
        $facility_name = $facility->Name;
        $chargent_orders  = Salesforce::query("SELECT ChargentOrders__Account__r.name,ChargentOrders__Account__c,ChargentOrders__Card_Expiration_Month__c,ChargentOrders__Card_Expiration_Year__c,ChargentOrders__Card_Last_4__c,ChargentOrders__Card_Month_Indicator__c,ChargentOrders__Card_Number__c,ChargentOrders__Card_Security_Code__c,ChargentOrders__Card_Type__c,ChargentOrders__Card_Year_Indicator__c,ChargentOrders__Charge_Amount__c,ChargentOrders__Manual_Charge__c,ChargentOrders__No_Tax__c,ChargentOrders__OrderSource__c,ChargentOrders__Payment_Frequency__c,ChargentOrders__Payment_Method__c,ChargentOrders__Payment_Received__c,ChargentOrders__Payment_Status__c,ChargentOrders__Tax_Exempt__c,ChargentOrders__Tax__c,ChargentOrders__Tokenization__c,ChargentOrders__Balance_Due__c,ChargentOrders__Bank_Account_Name__c,ChargentOrders__Bank_Account_Number__c,ChargentOrders__Bank_Account_Type__c,ChargentOrders__Bank_Name__c,ChargentOrders__Bank_Routing_Number__c,ChargentOrders__Billing_Address_Line_2__c,ChargentOrders__Billing_Address__c,ChargentOrders__Billing_City__c,ChargentOrders__Billing_Company__c,ChargentOrders__Billing_Country__c,ChargentOrders__Billing_Email__c,ChargentOrders__Billing_Fax__c,ChargentOrders__Billing_First_Name__c,ChargentOrders__Billing_Last_Name__c,ChargentOrders__Billing_Phone__c,ChargentOrders__Billing_State_Province__c,ChargentOrders__Billing_State__c,ChargentOrders__Billing_Zip_Postal__c,ChargentOrders__Subtotal__c,ChargentOrders__Status__c,Name,ChargentOrders__Date__c FROM ChargentOrders__ChargentOrder__c WHERE Name ='". $id ."'");
       $chargent_order = $chargent_orders->records;
        $charges[$facility_name] = $chargent_order;

        }
        
		return view('admin.orederview',compact('chargent_orders','title'));
	}
}