<?php
namespace App\Http\Controllers\admin;
use App\Http\Controllers\Controller;
use App\Http\Requests;
use App\Permission;
use Illuminate\Http\Request;
use Illuminate\Pagination\Paginator;
use Illuminate\Support\Facades\App;
//use App\Http\Controllers\admin\SforceBaseClient;
//File::require_once (app_path().'/sfdc/soapclient/SforceBaseClient.php');

/**
 * This file contains two classes.
 * @package SalesforceSoapClient
 */
/**
 * SforceEnterpriseClient class.
 *
 * @package SalesforceSoapClient
 */
class SforceEnterpriseClient extends SforceBaseClient {
  const ENTERPRISE_NAMESPACE = 'urn:enterprise.soap.sforce.com';

  function SforceEnterpriseClients() {
    $this->namespace = self::ENTERPRISE_NAMESPACE;
  }

  /**
   * Adds one or more new individual objects to your organization's data.
   * @param array $sObjects    Array of one or more sObjects (up to 200) to create.
   * @param AssignmentRuleHeader $assignment_header is optional.  Defaults to NULL
   * @param MruHeader $mru_header is optional.  Defaults to NULL
   * @return SaveResult
   */
  public function create($sObjects, $type) {
    foreach ($sObjects as &$sObject) {
    	// FIX for fieldsToNull issue - allow array in fieldsToNull (STEP #1)
   		$xmlStr = '';
    	if(isset($sObject->fieldsToNull) && is_array($sObject->fieldsToNull)) {
    		foreach($sObject->fieldsToNull as $fieldToNull) {
    			$xmlStr .= '<fieldsToNull>' . $fieldToNull . '</fieldsToNull>';
    		}
    	}
    	// ------
    	
      $sObject = new SoapVar($sObject, SOAP_ENC_OBJECT, $type, $this->namespace);

    	// FIX for fieldsToNull issue - allow array in fieldsToNull (STEP #2)
    	if($xmlStr != '') {
    		$sObject->enc_value->fieldsToNull = new SoapVar(new SoapVar($xmlStr, XSD_ANYXML), SOAP_ENC_ARRAY);
    	}
    	// ------
    }
    $arg = $sObjects;

    return parent::_create(new SoapParam($arg, "sObjects"));
  }

  /**
   * Updates one or more new individual objects to your organization's data.
   * @param array sObjects    Array of sObjects
   * @param AssignmentRuleHeader $assignment_header is optional.  Defaults to NULL
   * @param MruHeader $mru_header is optional.  Defaults to NULL
   * @return UpdateResult
   */
  public function update($sObjects, $type, $assignment_header = NULL, $mru_header = NULL) {

    foreach ($sObjects as &$sObject) {

    	// FIX for fieldsToNull issue - allow array in fieldsToNull (STEP #1)
   		$xmlStr = '';
    	if(isset($sObject->fieldsToNull) && is_array($sObject->fieldsToNull)) {
    		foreach($sObject->fieldsToNull as $fieldToNull) {
    			$xmlStr .= '<fieldsToNull>' . $fieldToNull . '</fieldsToNull>';
    		}
    	}
    	// ------
    	
    	$sObject = new SoapVar($sObject, SOAP_ENC_OBJECT, $type, $this->namespace);
    	
    	// FIX for fieldsToNull issue - allow array in fieldsToNull (STEP #2)
    	if($xmlStr != '') {
    		$sObject->enc_value->fieldsToNull = new SoapVar(new SoapVar($xmlStr, XSD_ANYXML), SOAP_ENC_ARRAY);
    	}
    	// ------
    }
    $arg = new stdClass;
    $arg->sObjects = $sObjects;
    return parent::_update($arg);
  }

  /**
   * Creates new objects and updates existing objects; uses a custom field to
   * determine the presence of existing objects. In most cases, we recommend
   * that you use upsert instead of create because upsert is idempotent.
   * Available in the API version 7.0 and later.
   *
   * @param string $ext_Id External Id
   * @param array  $sObjects Array of sObjects
   * @param string $type The type of objects being upserted.
   * @return UpsertResult
   */
  public function upsert($ext_Id, $sObjects, $type = 'Contact') {
    $arg = new stdClass;
    $arg->externalIDFieldName = new SoapVar($ext_Id, XSD_STRING, 'string', 'http://www.w3.org/2001/XMLSchema');
    foreach ($sObjects as &$sObject) {
      // FIX for fieldsToNull issue - allow array in fieldsToNull (STEP #1)
   	  $xmlStr = '';
      if(isset($sObject->fieldsToNull) && is_array($sObject->fieldsToNull)) {
    	foreach($sObject->fieldsToNull as $fieldToNull) {
    	  $xmlStr .= '<fieldsToNull>' . $fieldToNull . '</fieldsToNull>';
    	}
      }
      // ------
    	
      $sObject = new SoapVar($sObject, SOAP_ENC_OBJECT, $type, $this->namespace);

	  // FIX for fieldsToNull issue - allow array in fieldsToNull (STEP #2)
	  if($xmlStr != '') {
	  	$sObject->enc_value->fieldsToNull = new SoapVar(new SoapVar($xmlStr, XSD_ANYXML), SOAP_ENC_ARRAY);
	  }
	  // ------
    }
    $arg->sObjects = $sObjects;
    return parent::_upsert($arg);
  }

  /**
   * Merge records
   *
   * @param stdclass $mergeRequest
   * @param String $type
   * @return unknown
   */
  public function merge($mergeRequest, $type) {
    $mergeRequest->masterRecord = new SoapVar($mergeRequest->masterRecord, SOAP_ENC_OBJECT, $type, $this->namespace);
    $arg = new stdClass;
    $arg->request = new SoapVar($mergeRequest, SOAP_ENC_OBJECT, 'MergeRequest', $this->namespace);
    return parent::_merge($arg);
  }
}
?>
